unit UnitMain;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TfmMain = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Notify(Sender: TObject);
  end;

var
  fmMain: TfmMain;

implementation

uses
  SampleDLLHeaders,
  DelphiSupport;

{$R *.dfm}

procedure TfmMain.Button1Click(Sender: TObject);

  procedure Work(const AAPI: TSampleDLLProc);
  var
    API: ISampleDLLAPI;
    S: IStrings;
    X: Integer;
  begin
    AAPI(ISampleDLLAPI, API);
    API.InitDLL(nil);
    try
      S := API.GetData;
      Memo1.Clear;
      for X := 0 to S.Count - 1 do
        Memo1.Lines.Add(S[X]);
    finally
      API.DoneDLL;
    end;
  end;

var
  DLL: HMODULE;
  API: TSampleDLLProc;
begin
  DLL := LoadDLL(ExtractFilePath(ExtractFileDir(ParamStr(0))) + 'DLL\SampleDLL.dll');
  try
    API := GetProcAddress(DLL, SampleDLLProcName);
    Win32Check(Assigned(API));
    Work(API);
  finally
    FreeLibrary(DLL);
  end;
end;

var
  GDLL: HMODULE;
  GAPI: ISampleDLLAPI;

procedure TfmMain.Button2Click(Sender: TObject);
var
  DLL: HMODULE;
  APIFunc: TSampleDLLProc;
  API: ISampleDLLAPI;
begin
  DLL := LoadDLL(ExtractFilePath(ExtractFileDir(ParamStr(0))) + 'DLL\SampleDLL.dll');
  try
    APIFunc := GetProcAddress(DLL, SampleDLLProcName);
    Win32Check(Assigned(APIFunc));

    APIFunc(ISampleDLLAPI, API);
    API.InitDLL(nil);

    GAPI := API;
    API := nil;

    GDLL := DLL;
    DLL := 0;

  finally
    if API <> nil then
      API.DoneDLL;
    if DLL <> 0 then
      FreeLibrary(DLL);
  end;
  Button2.Enabled := False;
  Button3.Enabled := True;
  Button4.Enabled := True;
  Button5.Enabled := True;
  Button6.Enabled := True;
  Button7.Enabled := True;
  Button8.Enabled := True;
  Button9.Enabled := True;
end;

procedure TfmMain.Button8Click(Sender: TObject);
var
  Data: Pointer;
  Size: Cardinal;
begin
  Data := GAPI.GetMemory(Size);

  ShowMessage(Format('DLL returned %d bytes', [Size]));

  GAPI.Allocator.Free(Data);
end;

procedure TfmMain.Button9Click(Sender: TObject);
begin
  GAPI.NotifyMe(TNotify.Create(Notify));
end;

procedure TfmMain.Notify(Sender: TObject);
begin
  if Application.MessageBox('Got Notification' + sLineBreak + 'Continue running?',
    'Notification Received',
    MB_YESNO or MB_DEFBUTTON1 or MB_ICONINFORMATION) <> mrYes then
    Abort;
end;

procedure TfmMain.Button3Click(Sender: TObject);
begin
  GAPI.TryAbort;
end;

procedure TfmMain.Button4Click(Sender: TObject);
begin
  GAPI.TryAccessViolation;
end;

procedure TfmMain.Button5Click(Sender: TObject);
begin
  GAPI.TryWin32Exception;
end;

procedure TfmMain.Button6Click(Sender: TObject);
begin
  GAPI.TrySoftwareException;
end;

procedure TfmMain.Button7Click(Sender: TObject);
begin
  if GAPI <> nil then
  begin
    GAPI.DoneDLL;
    GAPI := nil;
  end;
  if GDLL <> 0 then
  begin
    FreeLibrary(GDLL);
    GDLL := 0;
  end;
  Button2.Enabled := True;
  Button3.Enabled := False;
  Button4.Enabled := False;
  Button5.Enabled := False;
  Button6.Enabled := False;
  Button7.Enabled := False;
  Button8.Enabled := False;
  Button9.Enabled := False;
end;

procedure TfmMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if Button7.Enabled then
    Button7Click(nil);
end;

end.
