unit SampleDLLHeaders;

{$I Defines.inc}

{$A8}
{$MINENUMSIZE 4}

interface

uses
  Windows,
  ActiveX;

type
  BSTR = WideString;
  LPWSTR = PWideChar;
  {$IFNDEF UNICODE}
  UnicodeString = WideString;
  NativeInt = Integer;
  NativeUInt = Cardinal;
  {$ENDIF}

  // Just in case
  IGetImplementation = interface
  ['{E28B1858-EC86-4559-8FCD-6B4F824151ED}']
    function GetSelf: Pointer; // TObject
  end;

  // Just an example
  IStrings = interface
  ['{7C29FB07-5C3D-4F0B-8F82-8B49758A60F4}']
    function GetCount: Integer; safecall;
    function GetString(const AIndex: Integer): BSTR; safecall;

    property Count: Integer read GetCount;
    property Strings[const AIndex: Integer]: BSTR read GetString; default;
  end;

  // Just an example
  INotify = interface
  ['{07FA30E4-FE9B-4ED2-8692-1E5CFEE4CF3F}']
    procedure Notify; safecall;
  end;

  // API of your DLL
  ISampleDLLAPI = interface
  ['{76C4EF34-3B11-4DFA-83E0-5D13AB3559AF}']
    // Mandatory methods for all DLLs
    function GetVersion: Integer; safecall;
    procedure InitDLL(AOptions: IUnknown); safecall;
    procedure DoneDLL; safecall;

    function GetAllocator: IMalloc; safecall;

    property Version: Integer read GetVersion;
    property Allocator: IMalloc read GetAllocator;

    // Examples are below, replace with your own code
    function GetData: IStrings; safecall;
    function GetMemory(out ADataSize: DWORD): Pointer; safecall;
    procedure NotifyMe(ANotifier: INotify); safecall;
    procedure TryAbort; safecall;
    procedure TryAccessViolation; safecall;
    procedure TryWin32Exception; safecall;
    procedure TrySoftwareException; safecall;
  end;

  TSampleDLLProc = procedure(const AIID: TGUID; var Intf); safecall;

const
  SampleDLLProcName    = 'GetAPI';

  CUSTOMER_BIT         = 1 shl 29;
  EAbortRaisedHRESULT  = HRESULT(E_ABORT or CUSTOMER_BIT);

  // ID of our model
  SampleDllIID: TGUID  = '{AA76E538-EF3C-4F35-9914-B4801B211A6D}';

  // Sample Error Codes
  // You can use them only when:
  // 1. 29th Customer bit must be set
  // 2. HRESULT must be FACILITY_ITF
  // 3. Error's GUID equals to SampleDllIID
  E_C_AbstractError               = $35A1;
  E_C_ArgumentException           = $80ED;
  E_C_ArgumentNilException        = $E0A0;
  E_C_ArgumentOutOfRangeException = $CEB5;
  E_C_BitsError                   = $93DD;
  E_C_ClassNotFound               = $CBA2;
  E_C_CodesetConversion           = $10C6;
  E_C_ComponentError              = $CD10;
  E_C_ConvertError                = $599A;
  E_C_DirectoryNotFoundException  = $D378;
  E_C_External                    = $2DF0;
  E_C_ExternalException           = $EE3F;
  E_C_FCreateError                = $8DEB;
  E_C_FileNotFoundException       = $CE9F;
  E_C_FilerError                  = $6677;
  E_C_FileStreamError             = $B0C7;
  E_C_FOpenError                  = $5C5D;
  E_C_HeapException               = $273E;
  E_C_InOutError                  = $EB24;
  E_C_IntError                    = $053E;
  E_C_IntfCastError               = $328D;
  E_C_InvalidCast                 = $C871;
  E_C_InvalidContainer            = $952F;
  E_C_InvalidImage                = $3CE9;
  E_C_InvalidInsert               = $EE6B;
  E_C_InvalidOperation            = $B715;
  E_C_InvalidOpException          = $8C3C;
  E_C_InvalidPointer              = $4F8B;
  E_C_ListError                   = $72A5;
  E_C_MathError                   = $023B;
  E_C_MethodNotFound              = $47F5;
  E_C_Monitor                     = $6295;
  E_C_MonitorLockException        = $482F;
  E_C_NoConstructException        = $233E;
  E_C_NoMonitorSupportException   = $5E14;
  E_C_OutOfResources              = $B2C5;
  E_C_PackageError                = $5447;
  E_C_ParserError                 = $CF64;
  E_C_PathTooLongException        = $2CC9;
  E_C_ProgrammerNotFound          = $F8CA;
  E_C_PropReadOnly                = $B6EA;
  E_C_PropWriteOnly               = $4783;
  E_C_Quit                        = $D7F4;
  E_C_RangeError                  = $E1B0;
  E_C_ReadError                   = $46AD;
  E_C_ResNotFound                 = $AF4A;
  E_C_StreamError                 = $49E3;
  E_C_StringListError             = $C014;
  E_C_VariantError                = $E2A8;
  E_C_WriteError                  = $EECE;

implementation

end.
