library SampleDLL;

{$WARN SYMBOL_PLATFORM OFF}

uses
  Windows,
  SysUtils,
  Classes,
  ActiveX,
  SampleDLLHeaders in 'SDK\SampleDLLHeaders.pas',
  DelphiSupport in 'SDK\DelphiSupport.pas',
  Unit1 in 'Unit1.pas';

{$R *.res}

type
  TSampleDLLAPI = class(TBaseObject, ISampleDLLAPI, ISupportErrorInfo)
  strict private
    FAllocator: IMalloc;
    FNotify: INotify;
  strict protected
    function GetVersion: Integer; safecall;
    procedure InitDLL(AOptions: IUnknown); safecall;
    procedure DoneDLL; safecall;
    function GetAllocator: IMalloc; safecall;

    // Useful payload examples:
    function GetData: IStrings; safecall;
    function GetMemory(out ADataSize: DWORD): Pointer; safecall;
    procedure NotifyMe(ANotifier: INotify); safecall;
    procedure TryAbort; safecall;
    procedure TryAccessViolation; safecall;
    procedure TryWin32Exception; safecall;
    procedure TrySoftwareException; safecall;
  public
    constructor Create; override;
  end;

var
  GAPI: ISampleDLLAPI;

constructor TSampleDLLAPI.Create;
begin
  inherited;
  SetName('Root DLL API Object');
end;

procedure TSampleDLLAPI.InitDLL(AOptions: IUnknown);
begin
  // does nothing in this DLL version, but can be used in the future versions
end;

procedure TSampleDLLAPI.DoneDLL;
begin
  FNotify := nil;
  FAllocator := nil;
  GAPI := nil;
end;

{ TSampleDLLAPI }

function TSampleDLLAPI.GetVersion: Integer;
begin
  Result := 1;
end;

function TSampleDLLAPI.GetAllocator: IMalloc;
begin
  if FAllocator = nil then
    FAllocator := TMalloc.Create;
  Result := FAllocator;
end;

// Simple examples:
function TSampleDLLAPI.GetData: IStrings;
var
  SampleData: array of String;
begin
  SetLength(SampleData, 5);
  SampleData[0] := 'Hello';
  SampleData[1] := 'from';
  SampleData[2] := 'Sample';
  SampleData[3] := 'DLL';
  SampleData[4] := '!';

  Result := TStrings.Create(SampleData);
end;

function TSampleDLLAPI.GetMemory(out ADataSize: DWORD): Pointer;
begin
  ADataSize := 1024;
  Result := AllocMem(ADataSize);
end;

procedure TSampleDLLAPI.NotifyMe(ANotifier: INotify);
begin
  FNotify := ANotifier;
end;

procedure TSampleDLLAPI.TryAbort;
begin
  if Assigned(FNotify) then
    FNotify.Notify;

  Abort;
end;

procedure TSampleDLLAPI.TryAccessViolation;
begin
  if Assigned(FNotify) then
    FNotify.Notify;

  PInteger(nil)^ := 0;
end;

procedure TSampleDLLAPI.TryWin32Exception;
begin
  if Assigned(FNotify) then
    FNotify.Notify;

  SetLastError(ERROR_ACCESS_DENIED);
  Win32Check(False);
end;

procedure TSampleDLLAPI.TrySoftwareException;
var
  List: TStringList;
begin
  if Assigned(FNotify) then
    FNotify.Notify;

  List := TStringList.Create;
  try
    List[0];
  finally
    FreeAndNil(List);
  end;
end;

//_____________________________________________

function GetAPI(const AIID: TGUID; var Intf): HRESULT; stdcall;
var
  IID: TGUID;
begin
  try
    IID := ISampleDLLAPI;
    if CompareMem(@AIID, @IID, SizeOf(IID)) then
    begin
      if GAPI = nil then
        GAPI := TSampleDLLAPI.Create;
      Pointer(Intf) := nil;
      ISampleDLLAPI(Intf) := GAPI;
      Result := S_OK;
    end
    else
      Result := E_NOINTERFACE;
    ActiveX.SetErrorInfo(0, nil);
  except
    on E: Exception do
      Result := DelphiSupport.HandleSafeCallException(E, ExceptAddr);
  end;
end;

exports
  GetAPI name SampleDLLProcName;

end.


