unit Unit1;

interface

uses
  Windows,
  SysUtils,
  Classes,
  ActiveX,
  SampleDLLHeaders,
  DelphiSupport;

type
  TStrings = class(TBaseObject, IStrings, ISupportErrorInfo)
  strict private
    FStrings: array of String;
  strict protected
    function GetCount: Integer; safecall;
    function GetString(const AIndex: Integer): BSTR; safecall;
  public
    constructor Create(const AStrings: array of String); reintroduce;
  end;

implementation

{ TStrings }

constructor TStrings.Create(const AStrings: array of String);
var
  X: Integer;
begin
  inherited Create;
  SetName('String Array, Count = ' + IntToStr(Length(AStrings)));

  SetLength(FStrings, Length(AStrings));
  for X := 0 to High(FStrings) do
    FStrings[X] := AStrings[X];
end;

function TStrings.GetCount: Integer;
begin
  Result := Length(FStrings);
end;

function TStrings.GetString(const AIndex: Integer): BSTR;
begin
  Result := FStrings[AIndex];
end;

end.
