// Options for VirtualMM
// You can edit this file or adjust conditional symbols in your project's options

//==============================================================================

// Comment to protect all memory (recommended for 64-bit apps).
// Uncomment to merge smaller memory blocks (default, recommended for 32-bit apps).
// Disabling this option will cause large address space consumption,
// so 64-bit app is recommended, while 32-bit app still can work to some extent.
{$DEFINE USE_SMALL_BLOCKS}

// Uncomment only one from below, comment other two:
// {$DEFINE PROTECT_RANDOM}      // randomly protect against buffer underflow or overflow
// {$DEFINE PROTECT_UNDERFLOW}   // protect against buffer underflow (accesses before a buffer)
{$DEFINE PROTECT_OVERFLOW}    // protect against buffer overflow (accesses after a buffer)
// Default is PROTECT_OVERFLOW (recommended).

// Comment to allocate memory at the first available address.
// Uncomment to allocate memory at the highest possible address (default, recommended).
{$DEFINE ALLOCATE_TOP_DOWN}

// Comment to concerve memory (default, recommended for 32-bit apps).
// Uncomment to catch using released memory (recommended for 64-bit apps).
// This option works by NEVER RELEASING MEMORY.
// In other words, the released (freed) memory remains released (uncomitted) and is never returned to the system.
// WARNING: your address space consumption will go through roof when you enable this option!
// 64-bit is highly recommended and is mandatory in most cases on practice.
// {$DEFINE CATCH_USE_AFTER_FREE}

// Comment for most cases (default).
// Uncomment if your IDE has a bug of releasing memory after shutdown.
// {$DEFINE NeverUninstall}

const
  // Sets the desired allocation alignment (granularity).
  // Must be a multiple of 8 (8, 16, 24, 32, 40, 48, 64, 128, etc.) for 32-bit app.
  // Must be a multiple of 16 (16, 32, 48, 64, 128, etc.) for 64-bit app.
  // Default Delphi memory manager (FastMM) aligns to 16 bytes (both 32-bit and 64-bit).
  // Classic Delphi memory manager (Delphi 7 era) aligns to 8 bytes.
  // This option has no effect if the PROTECT_UNDERFLOW option is enabled,
  // as all returned memory will be aligned to the page boundary (4096 by default).
  // Can be set to 1 to disable alignment - which is tecnhically forbidden in Delphi.
  // Can be set to 0 to use dynamic alignment (see System.GetMinimumBlockAlignment).
  // Default is 16 (recommended).
  VirtualMMAlign = 16;

{$IFDEF SUPPORTS_COMPILETIME_MESSAGES}
// Comment to disable warning.
// Not recommended, as VirtualMM is not for production!
// Default is uncommented (recommended).
{$MESSAGE WARN 'WARNING: VirtualMM is ON, do not use this build on production'}
{$ENDIF}

